<?php
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $article_id = $_POST['article_id'];
    $quantite_sortie = intval($_POST['quantite']);
    $commentaire = $_POST['commentaire'] ?? '';

    // Enregistrement du mouvement de sortie
    $stmt = $pdo->prepare("INSERT INTO mouvements (article_id, type, quantite, commentaire) VALUES (?, 'sortie', ?, ?)");
    $stmt->execute([$article_id, $quantite_sortie, $commentaire]);

    // Mise à jour de la quantité d'articles
    $stmt = $pdo->prepare("UPDATE articles SET quantite = quantite - ? WHERE id = ?");
    $stmt->execute([$quantite_sortie, $article_id]);

    // Vérification du seuil
    $stmt = $pdo->prepare("SELECT nom, quantite, seuil FROM articles WHERE id = ?");
    $stmt->execute([$article_id]);
    $article = $stmt->fetch();

    if ($article && $article['quantite'] < $article['seuil']) {
        $to = 'contact@oktox.com';
        $subject = "⚠️ Alerte stock bas - {$article['nom']}";
        $message = "Le stock de '{$article['nom']}' est passé sous le seuil critique (seuil : {$article['seuil']} / restant : {$article['quantite']}).";
        $headers = 'From: alert@oktox.com' . "\r\n" .
                   'Content-Type: text/plain; charset=UTF-8';

        mail($to, $subject, $message, $headers);
    }

    header('Location: index.php');
    exit;
}
?>

<!-- Formulaire simple de sortie de stock -->
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Sortie de Stock</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
  <div class="container mt-5">
    <h2>Sortie de Stock</h2>
    <form method="POST">
      <div class="mb-3">
        <label class="form-label">Sélectionner un article</label>
        <select class="form-select" name="article_id" required>
          <?php
          $stmt = $pdo->query("SELECT id, nom FROM articles ORDER BY nom");
          while ($row = $stmt->fetch()) {
            echo "<option value='{$row['id']}'>{$row['nom']}</option>";
          }
          ?>
        </select>
      </div>
      <div class="mb-3">
        <label class="form-label">Quantité sortie</label>
        <input type="number" name="quantite" class="form-control" required min="1">
      </div>
      <div class="mb-3">
        <label class="form-label">Commentaire (optionnel)</label>
        <textarea class="form-control" name="commentaire"></textarea>
      </div>
      <button type="submit" class="btn btn-danger">Valider la sortie</button>
    </form>
  </div>
</body>
</html>
