<?php
require_once 'config/db.php';

if (!isset($_GET['id'])) {
    header("Location: index.php");
    exit;
}

$id = $_GET['id'];

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $categorie = $_POST['categorie'];
    $nom = $_POST['nom'];
    $quantite = $_POST['quantite'];
    $seuil = $_POST['seuil'];

    $sql = "UPDATE stock SET categorie = ?, nom = ?, quantite = ?, seuil = ? WHERE id = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$categorie, $nom, $quantite, $seuil, $id]);

    header("Location: index.php");
    exit;
}

$sql = "SELECT * FROM stock WHERE id = ?";
$stmt = $pdo->prepare($sql);
$stmt->execute([$id]);
$element = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Modifier un élément</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container py-5">
        <div class="card shadow">
            <div class="card-header bg-warning text-white">
                <h4 class="mb-0">Modifier l'élément</h4>
            </div>
            <div class="card-body">
                <form method="post">
                    <div class="mb-3">
                        <label class="form-label">Catégorie</label>
                        <input type="text" name="categorie" class="form-control" value="<?= htmlspecialchars($element['categorie']) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Nom</label>
                        <input type="text" name="nom" class="form-control" value="<?= htmlspecialchars($element['nom']) ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Quantité</label>
                        <input type="number" name="quantite" class="form-control" value="<?= $element['quantite'] ?>" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Seuil</label>
                        <input type="number" name="seuil" class="form-control" value="<?= $element['seuil'] ?>" required>
                    </div>
                    <button type="submit" class="btn btn-primary">Enregistrer</button>
                    <a href="index.php" class="btn btn-secondary ms-2">Annuler</a>
                </form>
            </div>
        </div>
    </div>
</body>
</html>
