<?php
// Affichage des erreurs pour le debug
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Connexion à la base
require_once 'config/db.php';

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $categorie = $_POST['categorie'] ?? '';
    $nom = $_POST['nom'] ?? '';
    $quantite = $_POST['quantite'] ?? 0;
    $seuil = $_POST['seuil'] ?? 0;

    if (!empty($categorie) && !empty($nom)) {
        try {
            $sql = "INSERT INTO stock (categorie, nom, quantite, seuil) VALUES (:categorie, :nom, :quantite, :seuil)";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([
                ':categorie' => $categorie,
                ':nom' => $nom,
                ':quantite' => $quantite,
                ':seuil' => $seuil
            ]);
            header('Location: poteaux.php');
            exit;
        } catch (PDOException $e) {
            $message = 'Erreur SQL : ' . $e->getMessage();
        }
    } else {
        $message = 'Veuillez remplir tous les champs requis.';
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Ajouter un élément</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <h2 class="mb-4">Ajouter un élément</h2>

        <?php if (!empty($message)): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>

        <form method="POST" action="">
            <div class="mb-3">
                <label class="form-label">Catégorie</label>
                <input type="text" name="categorie" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Nom</label>
                <input type="text" name="nom" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Quantité</label>
                <input type="number" name="quantite" class="form-control" min="0" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Seuil</label>
                <input type="number" name="seuil" class="form-control" min="0" required>
            </div>
            <button type="submit" class="btn btn-primary">Ajouter</button>
            <a href="poteaux.php" class="btn btn-secondary">Retour</a>
        </form>
    </div>
</body>
</html>
