<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once __DIR__ . '/config/db.php';

try {
    $stmt = $pdo->prepare("SELECT * FROM stock WHERE categorie = :cat");
    $stmt->execute(['cat' => 'Équipement poteaux']);
    $elements = $stmt->fetchAll(PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("Erreur SQL : " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Inventaire Poteaux</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
    <h2>Inventaire Poteaux</h2>
    <a href="index.php" class="btn btn-secondary mb-3">← Retour à l'accueil</a>
    <a href="ajouter.php" class="btn btn-primary mb-3">+ Ajouter un élément</a>
    <table class="table table-striped">
        <thead class="table-dark">
            <tr>
                <th>Image</th>
                <th>Catégorie</th>
                <th>Nom</th>
                <th>Quantité</th>
                <th>Seuil</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($elements as $element): ?>
            <tr>
                <td><?= $element['image'] ? '<img src="uploads/' . $element['image'] . '" width="50"/>' : '<em>Aucune</em>' ?></td>
                <td><?= htmlspecialchars($element['categorie']) ?></td>
                <td><?= htmlspecialchars($element['nom']) ?></td>
                <td><?= htmlspecialchars($element['quantite']) ?></td>
                <td><?= htmlspecialchars($element['seuil']) ?></td>
                <td>
                    <a href="modifier.php?id=<?= $element['id'] ?>" class="btn btn-warning btn-sm">Modifier</a>
                    <a href="supprimer.php?id=<?= $element['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Supprimer cet élément ?');">Supprimer</a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
