<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once 'db.php';

try {
  $stmt = $pdo->prepare("SELECT * FROM articles WHERE nom LIKE '%poteaux%' ORDER BY nom ASC");
  $stmt->execute();
  $articles = $stmt->fetchAll();
} catch (PDOException $e) {
  die("Erreur SQL : " . $e->getMessage());
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Inventaire des Poteaux</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    img.thumb { width: 50px; height: auto; object-fit: contain; }
  </style>
</head>
<body>
<div class="container mt-4">
  <h2>Inventaire des Poteaux</h2>
  <a href="index.php" class="btn btn-secondary mb-3">← Retour à l’accueil</a>
  <a href="add_category.php" class="btn btn-success mb-3 float-end">+ Ajouter une Catégorie</a>
  <table class="table table-bordered table-hover">
    <thead class="table-dark">
      <tr>
        <th>Image</th>
        <th>Nom</th>
        <th>Quantité</th>
        <th>Seuil</th>
        <th>Actions</th>
      </tr>
    </thead>
    <tbody>
      <?php foreach ($articles as $row): ?>
        <tr>
          <td>
            <?php
              $imgPath = 'uploads/' . $row['image'];
              if (!empty($row['image']) && file_exists($imgPath)) {
                echo '<img src="' . htmlspecialchars($imgPath) . '" class="thumb">';
              } else {
                echo '-';
              }
            ?>
          </td>
          <td><?= htmlspecialchars($row['nom']) ?></td>
          <td><?= intval($row['quantite']) ?></td>
          <td><?= intval($row['seuil']) ?></td>
          <td>
            <a href="edit_item.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Modifier</a>
            <a href="delete_item.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Confirmer la suppression ?')">Supprimer</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>
</body>
</html>
