<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Inventaire Camion Tarière</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>img.thumb { height: 40px; }</style>
</head>
<body>
<div class="container mt-4">
  <h2>Inventaire Camion Tarière</h2>
  <a href='add_category.php' class='btn btn-success mb-3 float-end'>+ Ajouter une Catégorie</a>
  <a href="index.php" class="btn btn-secondary mb-3">← Retour</a>
  <table class="table table-bordered">
    <thead class="table-dark">
      <tr><th>Image</th><th>Nom</th><th>Quantité</th><th>Seuil</th><th>Actions</th></tr>
    </thead>
    <tbody>
      <?php
      $stmt = $pdo->prepare("SELECT * FROM articles a
        JOIN categories c ON a.categorie_id = c.id
        WHERE c.nom IN ('Camion tarière')
        ORDER BY c.nom, a.nom");
      $stmt->execute();
      while ($row = $stmt->fetch()) {
        $img = $row['image'] ? "<img src='uploads/{$row['image']}' class='thumb'>" : '';
        echo "<tr>
          <td>{$img}</td>
          <td>{$row['nom']}</td>
          <td>{$row['quantite']}</td>
          <td>{$row['seuil']}</td>
          <td><a href='edit_item.php?id={$row['id']}' class='btn btn-sm btn-warning'>Modifier</a></td>
        </tr>";
      }
      ?>
    </tbody>
  </table>
</div>
</body>
</html>
