<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Gestion de Stock</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>img.thumb { height: 40px; }</style>
</head>
<body>
  <nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
    <div class="container-fluid">
      <a class="navbar-brand" href="#">StockApp</a>
      <div class="collapse navbar-collapse">
        <ul class="navbar-nav ms-auto">
          <li class="nav-item"><a class="nav-link" href="dashboard.php">Dashboard</a></li>
          <li class="nav-item"><a class="nav-link" href="inventaire_nacelle.php">Inventaire Nacelle</a></li>
          <li class="nav-item"><a class="nav-link" href="inventaire_tariere.php">Inventaire Tarière</a></li>
          <li class="nav-item"><a class="nav-link" href="entree_stock.php">Entrée Stock</a></li>
          <li class="nav-item"><a class="nav-link" href="sortie_stock.php">Sortie Stock</a></li>
          <li class="nav-item"><a class="nav-link" href="export_pdf.php">Export PDF</a></li>
        </ul>
      </div>
    </div>
  </nav>

  <div class="container">
    <h2 class="mb-3">Inventaire Global (hors Nacelle & Tarière)</h2>
    <a class="btn btn-primary mb-3" href="add_item.php">+ Ajouter un élément</a>
    <table class="table table-bordered">
      <thead class="table-dark">
        <tr><th>Image</th><th>Catégorie</th><th>Nom</th><th>Quantité</th><th>Seuil</th><th>Actions</th></tr>
      </thead>
      <tbody>
        <?php
        $stmt = $pdo->prepare("SELECT articles.*, categories.nom AS categorie
          FROM articles
          JOIN categories ON articles.categorie_id = categories.id
          WHERE categories.nom NOT IN ('Camion tarière', 'Panier nacelle', 'Établi nacelle', 'Tiroirs nacelle')
          ORDER BY categories.nom, articles.nom");
        $stmt->execute();
        while ($row = $stmt->fetch()) {
          $img = $row['image'] ? "<img src='uploads/{$row['image']}' class='thumb'>" : '';
          $badge = $row['quantite'] < $row['seuil'] ? " <span class='badge bg-danger'>Alerte</span>" : "";
          echo "<tr>
            <td>{$img}</td>
            <td>{$row['categorie']}</td>
            <td>{$row['nom']}</td>
            <td>{$row['quantite']}</td>
            <td>{$row['seuil']}</td>
            <td><a href='edit_item.php?id={$row['id']}' class='btn btn-sm btn-warning'>Modifier</a>{$badge}</td>
          </tr>";
        }
        ?>
      </tbody>
    </table>
  </div>
</body>
</html>
