<?php
include 'db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $article_id = $_POST['article_id'];
    $quantite_entree = intval($_POST['quantite']);
    $commentaire = $_POST['commentaire'] ?? '';

    // Enregistrement du mouvement d'entrée
    $stmt = $pdo->prepare("INSERT INTO mouvements (article_id, type, quantite, commentaire) VALUES (?, 'entrée', ?, ?)");
    $stmt->execute([$article_id, $quantite_entree, $commentaire]);

    // Mise à jour de la quantité d'articles
    $stmt = $pdo->prepare("UPDATE articles SET quantite = quantite + ? WHERE id = ?");
    $stmt->execute([$quantite_entree, $article_id]);

    header('Location: index.php');
    exit;
}
?>

<!-- Formulaire simple d'entrée de stock -->
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Entrée de Stock</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
  <div class="container mt-5">
    <h2>Entrée de Stock</h2>
    <form method="POST">
      <div class="mb-3">
        <label class="form-label">Sélectionner un article</label>
        <select class="form-select" name="article_id" required>
          <?php
          $stmt = $pdo->query("SELECT id, nom FROM articles ORDER BY nom");
          while ($row = $stmt->fetch()) {
            echo "<option value='{$row['id']}'>{$row['nom']}</option>";
          }
          ?>
        </select>
      </div>
      <div class="mb-3">
        <label class="form-label">Quantité entrée</label>
        <input type="number" name="quantite" class="form-control" required min="1">
      </div>
      <div class="mb-3">
        <label class="form-label">Commentaire (optionnel)</label>
        <textarea class="form-control" name="commentaire"></textarea>
      </div>
      <button type="submit" class="btn btn-success">Valider l'entrée</button>
    </form>
  </div>
</body>
</html>
