<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Gestion des Catégories</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <script>
    function confirmerSuppression(nom, id) {
      if (confirm("⚠️ Voulez-vous vraiment supprimer la catégorie '" + nom + "' ainsi que tous les articles associés ?")) {
        window.location.href = "delete_category.php?id=" + id;
      }
    }
  </script>
</head>
<body>
<div class="container mt-4">
  <h2>Liste des Catégories</h2>
  <a href="index.php" class="btn btn-secondary mb-3">← Retour</a>
  <table class="table table-bordered">
    <thead class="table-dark">
      <tr><th>Nom</th><th>Actions</th></tr>
    </thead>
    <tbody>
      <?php
      $stmt = $pdo->query("SELECT * FROM categories ORDER BY nom");
      while ($row = $stmt->fetch()) {
        echo "<tr>
          <td>{$row['nom']}</td>
          <td>
            <a href='edit_category.php?id={$row['id']}' class='btn btn-sm btn-warning'>Modifier</a>
            <button onclick=\"confirmerSuppression('{$row['nom']}', {$row['id']})\" class='btn btn-sm btn-danger'>Supprimer</button>
          </td>
        </tr>";
      }
      ?>
    </tbody>
  </table>
</div>
</body>
</html>
