<?php include 'db.php'; ?>
<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <title>Ajouter une Catégorie</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body>
<div class="container mt-4">
  <h2>Ajouter une Catégorie</h2>
  <form method="post">
    <div class="mb-3">
      <label for="nom" class="form-label">Nom de la Catégorie</label>
      <input type="text" class="form-control" name="nom" required>
    </div>
    <button type="submit" class="btn btn-primary">Ajouter</button>
    <a href="categories.php" class="btn btn-secondary">Annuler</a>
  </form>
  <?php
  if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nom = trim($_POST['nom']);
    $stmt = $pdo->prepare("INSERT INTO categories (nom) VALUES (?)");
    if ($stmt->execute([$nom])) {
      echo "<div class='alert alert-success mt-3'>✅ Catégorie ajoutée avec succès.</div>";
    } else {
      echo "<div class='alert alert-danger mt-3'>❌ Erreur lors de l'ajout.</div>";
    }
  }
  ?>
</div>
</body>
</html>
