<?php
require_once 'config/db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $categorie = $_POST["categorie"];
    $nom = $_POST["nom"];
    $quantite = $_POST["quantite"];
    $seuil = $_POST["seuil"];

    $sql = "INSERT INTO stock (categorie, nom, quantite, seuil) VALUES (?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$categorie, $nom, $quantite, $seuil]);

    header("Location: poteaux.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Ajouter un élément</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
    <div class="container mt-5">
        <h2 class="mb-4">Ajouter un nouvel élément</h2>
        <form method="post">
            <div class="mb-3">
                <label class="form-label">Catégorie</label>
                <input type="text" name="categorie" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Nom</label>
                <input type="text" name="nom" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Quantité</label>
                <input type="number" name="quantite" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Seuil</label>
                <input type="number" name="seuil" class="form-control" required>
            </div>
            <button type="submit" class="btn btn-success">Ajouter</button>
            <a href="poteaux.php" class="btn btn-secondary">Annuler</a>
        </form>
    </div>
</body>
</html>